function isSectorPassable(sector)
	
	if (isValid(sector)) then
		return Sectors[sector].enabled
	else
		return true
	end

end

function belongsToEnemy(force, sector)

	if not(isValid(sector)) then
		return false
	end

	local sector_owner = Sectors[sector].owner
	local relation = Forces[force][sector_owner]
	--log("_path_finder_", "belongsToEnemy", force, sector, "owner",sector_owner, "relation", relation)
	if (relation == ENEMY) then
		return true
	end
	
	return false

end


function findPath(force, source, target)
	
	--log("_path_finder_", "findPath", force, source, target)
	if not(isSectorPassable(target)) then
		log("_path_finder_", "  ", target)
		return { found = false, path = nil, time = nil }
	end
	
	if ((force == PLAYER) and (not(isSectorPassable(source)))) then
	--if not(isSectorPassable(source)) then
		log("_path_finder_", "   ", source)
		return { found = false, path = nil, time = nil }
	end
	
	if (belongsToEnemy(force, source)) then
		log("_path_finder_", "   ", source, force)
		return { found = false, path = nil, time = nil }
	end
		
--	local isCBP = false
--	
--	local check_cbp = function(index, s)
--		if (((s == source) and (Sectors[s].owner ~= force) and (Sectors[s].owner ~= CURRENT_ALLY))) then
--			isCBP = true
--		end
--	end
--	
--	table.foreach(CBP, check_cbp)
	
--	local test = nil
--	
--	if ((isValid(source)) and (isValid(target))) then
--		if (source ~= target) then
--			test = Joints[source][target]
--		end
--	end

--	if ((isCBP == true) and ((getGVAR("PAPERS_WORKED") == _NO) or (getGVAR("GOT_PAPERS") == _NO)))then
--		if (isValid(test)) then
--			if (test.blockpost == true) then
--				return { found = false, path = nil, time = nil }
--			end
----		else
----			return { found = false, path = nil, time = nil }
--		end
--	end

	
	local open_list = {}
	local closed_list = {}
		
	local open_list_size = 0
		
	
	open_list[target] = 1
	open_list_size = open_list_size + 1
		
	local costs = {}
	costs[target] = 0
	
	log("global_map", "source = ", target)
	log("global_map", "target = ", source)
	
	local parents = {}
		
	
	--log("_path_finder_", "SEARCH1")
	while open_list_size ~= 0 do
	
		local res = 0
		local current_min_cost = 9999
		local findMinCostNode = function(index, value)
			if (costs[index] < current_min_cost) then
				res = index
				current_min_cost = costs[index]
			end
		end
		
		table.foreach(open_list, findMinCostNode)
		
		
		local best_node = res
		
		local foo = function(index, value)
		
			if ((force == PLAYER) and (not(isSectorPassable(index)))) then
				return
			end
			
			if ((Sectors[index].owner ~= CURRENT_ALLY) and Sectors[index].blockpost and not(Sectors[index].papers_worked)) then
				if (Joints[index][best_node].blockpost) then
					return
				end
			end
			
			local new_cost = costs[best_node] + Joints[best_node][index].distance
		
			if (open_list[index] == nil and closed_list[index] == nil) then
				
					costs[index] = new_cost
					parents[index] = best_node
					open_list[index] = 1
					open_list_size = open_list_size + 1
					
			elseif (costs[index] == nil) then 
				
				costs[index] = new_cost
				parents[index] = best_node
				
			elseif (new_cost < costs[index]) then
			
				costs[index] = new_cost
				parents[index] = best_node
		
			end

		end
		
		table.foreach(Joints[best_node], foo)
				
		open_list[best_node] = nil
		open_list_size = open_list_size - 1
		closed_list[best_node] = 1
				
		if (best_node == source) then
			open_list_size = 0
		end
	
	end
		
	--log("_path_finder_", "SEARCH2")
	local path = {}
	
	local waypoint_index = 1
		
	local current_waypoint = source
	local not_path_builded = true
	
	local sectorToFight = nil
	local sectorToRetreat = nil
	
	local prev_waypoint = nil
	
	while ((not_path_builded == true) and (isValid(current_waypoint))) do
	
		log("global_map", "adding", current_waypoint)	

		--log("_path_finder_", "waypoint", "force", force, "wp", current_waypoint)
		if (belongsToEnemy(force, current_waypoint)) then
			not_path_builded = false
			sectorToFight = current_waypoint
			--log("_path_finder_", "sectorToFight", current_waypoint)
		end
		--
		if (prev_waypoint == nil) then
			if (Joints[source][current_waypoint] ~= nil) then
				sectorToRetreat = source
			end
		else
			sectorToRetreat = prev_waypoint
		end
		--
--		local blockpost_test = nil
	
--		if ((current_waypoint ~= parents[current_waypoint]) and (isValid(parents[current_waypoint])) and (isValid(current_waypoint))) then
--			blockpost_test = Joints[current_waypoint][parents[current_waypoint]]
--		end
		--local blockpost_test = Joints[current_waypoint][parents[current_waypoint]]
		
--		if (isValid(blockpost_test)) then
--			if ((blockpost_test.blockpost == true) and (Sectors[current_waypoint].owner ~= force)) then
--				not_path_builded = false
--				sectorToFight = current_waypoint
--				table.insert(CBP, current_waypoint)
----				sectorToRetreat = prev_waypoint
--			end
--		end
		
		path[waypoint_index] = current_waypoint
		waypoint_index = waypoint_index + 1
		
		if (current_waypoint == target) then
			not_path_builded = false
		end

		prev_waypoint = current_waypoint
		current_waypoint = parents[current_waypoint]
		
	end
	
	if not_path_builded then
		--log("_path_finder_", "RETURN1")
		return { found = false, path = nil, time = nil }
	end
		
	local total_path = nil
	
--	local remove_cbp = function(index, s)
--		if (s == prev_waypoint) then
--			table.remove(CBP, index)
--		end
--	end
--	
--	table.foreach(CBP, check_cbp)
	
	local prev_waypoint = nil
	
	local total_time = 0

	local outputpath = function(index, value)
	
		if (prev_waypoint ~= nil) then
		
			if (total_path == nil) then
				total_path = Joints[prev_waypoint][value].path
				total_time = Joints[prev_waypoint][value].distance
			else
				total_path = total_path..","..Joints[prev_waypoint][value].path
				total_time = total_time + Joints[prev_waypoint][value].distance
			end
		
		end
		
		prev_waypoint = value
		
	end
	
	table.foreach(path, outputpath)

	--log("_path_finder_", "SEARCH3")
	return { found = true, path = total_path, time = total_time, fight_sector = sectorToFight, retreat_sector = sectorToRetreat }
	
end
